/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.internal.actions;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.git.core.github.IGithubPullRequest;
import com.aptana.git.core.github.IGithubRepository;
import com.aptana.git.core.model.GitRepository;
import com.aptana.git.ui.GitUIPlugin;
import com.aptana.git.ui.dialogs.MergePullRequestDialog;
import com.aptana.git.ui.internal.actions.AbstractGitHandler;
import com.aptana.git.ui.internal.actions.Messages;
import com.aptana.git.ui.internal.preferences.GithubAccountPageProvider;
import com.aptana.ui.dialogs.HyperlinkInfoPopupDialog;
import com.aptana.ui.util.UIUtils;
import com.aptana.ui.util.WorkbenchBrowserUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractGithubHandler
extends AbstractGitHandler {
    protected IGithubRepository getGithubRepo() throws ExecutionException {
        GitRepository repo = this.getSelectedRepository();
        if (repo == null) {
            throw new ExecutionException(Messages.CreatePullRequestHandler_NoRepoErr);
        }
        IGithubRepository ghRepo = null;
        while (ghRepo == null) {
            try {
                ghRepo = repo.getGithubRepo();
            }
            catch (CoreException ce) {
                if (ce.getStatus().getCode() == 1234) {
                    final GithubAccountPageProvider userInfoProvider = new GithubAccountPageProvider();
                    Dialog dialog = new Dialog(UIUtils.getActiveShell()){

                        protected Control createDialogArea(Composite parent) {
                            Composite composite = (Composite)super.createDialogArea(parent);
                            Control userInfoControl = userInfoProvider.createContents(composite);
                            userInfoControl.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(3, 1).create());
                            return composite;
                        }

                        protected void okPressed() {
                            if (!userInfoProvider.performOk()) {
                                return;
                            }
                            super.okPressed();
                        }
                    };
                    if (dialog.open() != 1) continue;
                    return null;
                }
                throw new ExecutionException(ce.getMessage(), (Throwable)ce);
            }
        }
        return ghRepo;
    }

    protected boolean calculateEnabled() {
        GitRepository repo = this.getSelectedRepository();
        if (repo == null) {
            return false;
        }
        return repo.hasGithubRemote();
    }

    public static void viewPullRequest(IGithubPullRequest pr) {
        URL url = null;
        try {
            url = pr.getHTMLURL();
        }
        catch (MalformedURLException e1) {
            IdeLog.logError((Plugin)GitUIPlugin.getDefault(), (Throwable)e1);
        }
        final String prURL = url == null ? "" : url.toString();
        UIUtils.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (!StringUtil.isEmpty((String)prURL)) {
                    WorkbenchBrowserUtil.launchExternalBrowser((String)prURL);
                }
            }
        });
    }

    public static void mergePullRequest(final GitRepository repo, final IGithubPullRequest pr) {
        MergePullRequestDialog prDialog = new MergePullRequestDialog(UIUtils.getActiveShell(), pr);
        if (prDialog.open() != 0) {
            return;
        }
        final String msg = prDialog.getCommitMessage();
        final boolean deleteBranch = prDialog.deleteBranch();
        Job job = new Job("Merging pull request..."){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus deleteStatus;
                IStatus status = pr.merge(msg, monitor);
                if (!status.isOK()) {
                    return status;
                }
                if (deleteBranch && !(deleteStatus = repo.push(new String[]{"origin", ":" + pr.getHeadRef()})).isOK()) {
                    return deleteStatus;
                }
                URL url = null;
                try {
                    url = pr.getHTMLURL();
                }
                catch (MalformedURLException e1) {
                    IdeLog.logError((Plugin)GitUIPlugin.getDefault(), (Throwable)e1);
                }
                final String prURL = url == null ? "" : url.toString();
                UIUtils.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        HyperlinkInfoPopupDialog toolTip = new HyperlinkInfoPopupDialog(UIUtils.getActiveShell(), "Pull Request Merged", MessageFormat.format("Successfully merged and closed pull request <a href=\"{0}\">#{1}</a>.", prURL, pr.getNumber()), (SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                AbstractGithubHandler.viewPullRequest(pr);
                            }
                        });
                        toolTip.open();
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }
}

